//
//  OPImageServiceCommon.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-06-24.
//
//

#import <Foundation/Foundation.h>
#import "OPDataMonitorProtocol.h"
#import "OPDataModuleProtocol.h"
#import "OPImageDataOperation.h"

@protocol OPGenericProfile;
@class OPItem;

@interface OPDataOperationCommon : NSObject

// Used to determine icon size
+ (CGFloat)iconSizeForItemImage:(OPItemImage)imageType;
+ (CGFloat)iconSizeForCustomItemImage:(OPItemImage)imageType;

+ (CGFloat)iconSizeForProfileImage:(OPProfileImage)imageType;

// Image Service
+ (id <OPDataModule>)dataModuleForImageServiceForItem:(OPItem *)item imageType:(OPItemImage)imageType imageScale:(CGFloat)scale;

// Data module that returns a image like OP4 does including a custom Icon
+ (id <OPDataModule>)dataModuleForItemImageOfTypeImageType:(OPItemImage)imageType item:(OPItem *)item;

// Creates a module that is wrapped in a data operation with the accessing block being what is executed.
+ (id <OPDataOperationMonitor>)genericDataOperationWithAccessBlock:(id(^)(void))accessingBlock identifier:(NSString *)identifier completion:(void(^)(id image, NSError *error))completionBlock;

// A block that will return the placeholder image for an item
+ (id(^)(void))workBlockForPlaceholderImageForItem:(OPItem *)item imageOfTypeImageType:(OPItemImage)imageType;
@end
